Sender: vip@bournemouth-net.co.uk
Received: from odin.bournemouth-net.co.uk (post.bournemouth-net.co.uk [194.176.131.1]) by dub-img-6.compuserve.com (8.6.10/5.950515)
	id MAA21706; Fri, 24 May 1996 12:57:53 -0400
Received: from bournemouth-net.co.uk.bournemouth-net.co.uk (dialup10.bournemouth-net.co.uk [194.176.132.41]) by odin.bournemouth-net.co.uk (8.6.11/8.6.11) with SMTP id RAA21461 for <75443.134@CompuServe.COM>; Fri, 24 May 1996 17:57:34 +0100
Message-ID: <31A5EA94.2AB7@bournemouth-net.co.uk>
Date: Fri, 24 May 1996 17:57:56 +0100
From: Mark C Brooks <vip@bournemouth-net.co.uk>
Organization: VIP Limited
X-Mailer: Mozilla 2.0 (Win95; I)
MIME-Version: 1.0
To: 75443.134@CompuServe.COM
Subject: Delphi 2.0 And VBIS4032
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 7bit

Tony, 

As promised, here is what I have so far. It's unfinished, but it proves 
that it'll work ok! Any comments would be greatly appreciated. Note that 
this is a component, not a standard unit.

Mark

unit IsamTool;

//**********************************************************************************************************************
// VB\ISAM4032 Component Unit
// VIP (C) 1996
// Mark C Brooks
//**********************************************************************************************************************

interface

uses
  Classes, SysUtils;

const

  // The VBIS4032 license key

  LicKey                     = 'MU32BROOKSM3A270CF5';

  // Return codes

  VIS_OK                     = 0;
  VIS_NOT_FOUND              = 1;
  VIS_UPDATE_VIOLATION       = 2;
  VIS_ACCESS_DENIED          = 3;
  VIS_BAD_DATASET_NUMBER     = 4;
  VIS_BAD_FORMAT             = 5;
  VIS_INVALID_KEY            = 6;
  VIS_BAD_PARAMETER_VALUE    = 7;
  VIS_BAD_FILE               = 8;
  VIS_ALREADY_EXISTS         = 9;
  VIS_NO_ROOM                = 10;
  VIS_DISK_FULL              = 11;
  VIS_OUT_OF_MEMORY          = 12;
  VIS_DOS_ERROR              = 13;
  VIS_DISK_ERROR             = 14;
  VIS_DATA_VALIDITY_CHECK    = 15;
  VIS_INVALID_SECONDARY_KEY  = 16;
  VIS_SEQUENCE_ERROR         = 17;
  VIS_OUT_OF_FILE_HANDLES    = 18;
  VIS_BUSY                   = 19;
  VIS_INVALID_PASSWORD       = 20;
  VIS_FUNCTION_NOT_AVAILABLE = 21;
  VIS_INTERUPTED             = 22;
  VIS_ALREADY_OPEN           = 23;

  // Open modes

  READ_ONLY                  = 0;
  READ_WRITE                 = 1;
  READ_ONLY_SHARED           = 2;
  READ_WRITE_SHARED          = 3;

  // Cache sizes

  NO_CACHE                   = -1;
  SMALL_CACHE                = 0;
  LARGE_CACHE                = 1;

  // VmxGet flags

  XNOFINDER                  = 1;
  XLOOKUP                    = 1;
  XNEXT                      = 2;
  XPREVIOUS                  = 4;
  XCURRENT                   = 8;

  XANY                       = 16;
  XEQ                        = 32;
  XBEGINS                    = 64;
  XNOT                       = 128;
  XLT                        = 256;
  XGT                        = 512;
  XLE                        = 1024;
  XGE                        = 2048;

  XGET_DATA                  = 4096;
  XNO_DATA                   = 8192;
  XNATIVE                    = 16384;

  // VmxPut flags

  ADD_OR_REPLACE             = 0;
  ADD_ONLY                   = 1;
  REPLACE_ONLY               = 2;

type

  // Define the TIsamTool component

  TIsamTool = class(TComponent)
  private

    // Private fields

    fOpen: boolean;
    fHandle: longint;
    fDataset: string;
    fVersion: string;
    fPrimaryKey: string;
    fLastError: smallint;

    // Private functions to handle property reads and writes

    function GetRecordCount: longint;
    function GetFormatString: string;
    function GetNextPrimaryKey: string;
    procedure SetVersion(const V: string);
    function GetPrimaryKeyLength: smallint;

  public

    // Constructor and destructor methods

    destructor Destroy; override;
    constructor Create(AOwner: TComponent); override;

    // Public methods

    function Close:     boolean;
    function Delete    (const PKey: string): boolean;
    function Kill      (const DSet: string): boolean;
    function UnLock    (const LString: string): boolean;
    function Lock      (const LString: string): boolean;
    function Bof       (const Index: smallint): boolean;
    function Eof       (const Index: smallint): boolean;
    function ReadNote  (const Name: string; var Contents: string): 
boolean;
    function Add       (const RecAddr: pointer; const PKey: string): 
boolean;
    function Replace   (const RecAddr: pointer; const PKey: string): 
boolean;
    function WriteNote (const Name: string; const Contents: string): 
boolean;
    function Open      (const DSet: string; const AccessMode: smallint): 
boolean;
    function Lookup    (const RecAddr: pointer; const Index: smallint; 
const Selector: string): boolean;
    function CreateNew (const DSet: string; const MaxPKeyLength: 
smallint; const StandardFormat: string): boolean;
    function Next      (const RecAddr: pointer; const Index: smallint; 
const Selector: string; const Compare: smallint): boolean;
    function Prev      (const RecAddr: pointer; const Index: smallint; 
const Selector: string; const Compare: smallint): boolean;

    // Public properties

    property Handle: longint read fHandle;
    property Dataset: string read fDataset;
    property LastError: smallint read fLastError;
    property PrimaryKey: string read fPrimaryKey;
    property RecordCount: longint read GetRecordCount;
    property FormatString: string read GetFormatString;
    property PrimaryKeyLength: smallint read GetPrimaryKeyLength;

  published

    // Published properties for the object inspector

    property Version: string read fVersion write SetVersion;
  end;

  // Define the TIsamInfoRec record

  TIsamInfoRec = record
    RecordsInFile:         longint;
    GroupsUsed:            smallint;
    AllocatedGpsAvail:     smallint;
    MaxPrimaryKeyLen:      smallint;
    Pad1:                  smallint;
    GroupSize:             longint;
    InitialAllocation:     smallint;
    IncrementalAllocation: smallint;
    FreeFileNoteSpace:     smallint;
    Pad2:                  smallint;
    StandardFormat:        string;
    Reserved:              string;
  end;

  // Define pointer types for the VBIS4032 function parameters

  TStringPtr      = ^string;
  TLongIntPtr     = ^longint;
  TSmallIntPtr    = ^smallint;
  TIsamInfoRecPtr = ^TIsamInfoRec;

// Declare the VBIS4032 functions that the component requires

function VmxCreate    (DatasetName:      TStringPtr;
                       MaxPrimaryKeyLen: TSmallIntPtr;
                       GpSz:             TLongIntPtr;
                       InitAlloc:        TSmallIntPtr;
                       Options:          TSmallIntPtr;
                       StandardFormat:   TStringPtr): smallint; far 
stdcall;

function VmxOpen      (DatasetName:      TStringPtr;
                       CacheSize:        TSmallIntPtr;
                       AccessMode:       TSmallIntPtr;
                       RDatasetNo:       TLongIntPtr;
                       LicenseKey:       TStringPtr): smallint; far 
stdcall;

function VmxClose     (DatasetNo:        TLongIntPtr): smallint; far 
stdcall;

function VmxGet       (DatasetNo:        TLongIntPtr;
                       Index:            TSmallIntPtr;
                       Options:          TSmallIntPtr;
                       Selector:         TStringPtr;
                       RIndexEntry:      TStringPtr;
                       RPrimaryKey:      TStringPtr;
                       RRecordVariable:  pointer): smallint; far 
stdcall;

function VmxPut       (DatasetNo:        TLongIntPtr;
                       PrimaryKey:       TStringPtr;
                       RecordVariable:   pointer;
                       UpdateMode:       TSmallIntPtr): smallint; far 
stdcall;

function VmxDelete    (DatasetNo:        TLongIntPtr;
                       PrimaryKey:       TStringPtr): smallint; far 
stdcall;

function VmxBOF       (DatasetNo:        TLongIntPtr;
                       Index:            TSmallIntPtr): smallint; far 
stdcall;

function VmxEOF       (DatasetNo:        TLongIntPtr;
                       Index:            TSmallIntPtr): smallint; far 
stdcall;

function VmxInfo      (DatasetNo:        TLongIntPtr;
                       RInfoStructure:   TIsamInfoRecPtr): smallint; far 
stdcall;

function VmxLock      (DatasetNo:        TLongIntPtr;
                       LockString:       TStringPtr): smallint; far 
stdcall;

function VmxUnlock    (DatasetNo:        TLongIntPtr;
                       LockString:       TStringPtr): smallint; far 
stdcall;

function VmxKill      (DatasetName:      TStringPtr): smallint; far 
stdcall;

function VmxReadNote  (DatasetNo:        TLongIntPtr;
                       NoteName:         TStringPtr;
                       RNoteContents:    TStringPtr): smallint; far 
stdcall;

function VmxWriteNote (DatasetNo:        TLongIntPtr;
                       NoteName:         TStringPtr;
                       NoteContents:     TStringPtr): smallint; far 
stdcall;

// Declare the register procedure

procedure Register;

// Implement the code for the unit

implementation

//**********************************************************************************************************************
// Create
// Overrides the create method to initialise properties and internal 
variables.
//**********************************************************************************************************************

constructor TIsamTool.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fLastError := VIS_OK;
  fVersion   := '1.00';
  fOpen      := False;
end;

//**********************************************************************************************************************
// Destroy
// Overrides the destroy method to free any allocated resources
//**********************************************************************************************************************

destructor TIsamTool.Destroy;
begin
  Self.Close;
  inherited Destroy;
end;

//**********************************************************************************************************************
// SetVersion
// Stops the version number from being changed
//**********************************************************************************************************************

procedure TIsamTool.SetVersion(const V: string);
begin
end;

//**********************************************************************************************************************
// GetRecordCount
// Returns the current number of records in the dataset or -1 on failure
//**********************************************************************************************************************

function TIsamTool.GetRecordCount: longint;
var
  IsamInfoRec: TIsamInfoRec;
begin

  // Get info for the dataset

  fLastError := VmxInfo(@fHandle,
                        @IsamInfoRec);

  // Return the number of records

  if fLastError = VIS_OK then
    Result := IsamInfoRec.RecordsInFile
  else
    Result := -1;
end;

//**********************************************************************************************************************
// GetFormatString
// Returns the current dataset format string or nil on failure
//**********************************************************************************************************************

function TIsamTool.GetFormatString: string;
var
  IsamInfoRec: TIsamInfoRec;
begin

  // Get info for the dataset

  fLastError := VmxInfo(@fHandle,
                        @IsamInfoRec);

  // Return the standard format string

  if fLastError = VIS_OK then
    Result := IsamInfoRec.StandardFormat
  else
    Result := '';
end;

//**********************************************************************************************************************
// GetPrimaryKeyLength
// Returns the maximum primary key length for the dataset
//**********************************************************************************************************************

function TIsamTool.GetPrimaryKeyLength: smallint;
var
  IsamInfoRec: TIsamInfoRec;
begin

  // Get info for the dataset

  fLastError := VmxInfo(@fHandle,
                        @IsamInfoRec);

  // Return the maximum primary key length

  if fLastError = VIS_OK then
    Result := IsamInfoRec.MaxPrimaryKeyLen
  else
    Result := -1;
end;

//**********************************************************************************************************************
// GetNextPrimaryKey
// Returns the next logical primary key for the dataset
//**********************************************************************************************************************

function TIsamTool.GetNextPrimaryKey: string;
var
  L: longint;
  Pkl: smallint;
  Index: smallint;
  Selector: string;
  Options: smallint;
  RIndexEntry: string;
  RPrimaryKey: string;
  RRecordVariable: pointer;
begin
  Index := 0;
  Result := '';

  // Move to the end of the dataset

  if VmxEOF(@fHandle,@Index) <> VIS_OK then
    Exit;

  // Setup the input values

  Pkl := GetPrimaryKeyLength;
  Options := XPREVIOUS + XNO_DATA;
  RRecordVariable := nil;

  // Try to get the previous record

  if 
VmxGet(@fHandle,@Index,@Options,@Selector,@RIndexEntry,@RPrimaryKey,@RRecordVariable) <> VIS_OK then
    Result := Format('%*.*d',[Pkl,Pkl,1])
  else
    begin
      L := StrToInt(RPRimaryKey);
      Inc(L);
      Result := Format('%*.*d',[Pkl,Pkl,L]);
    end;
end;

//**********************************************************************************************************************
// Open
// Opens the specified dataset with the specified access rights
//**********************************************************************************************************************

function TIsamTool.Open(const DSet: string; const AccessMode: smallint): 
boolean;
var
  LicenseKey: string;
  CacheSize: smallint;
begin
  Result := False;

  // Check that a dataset is not already open

  if fOpen then
    begin
      fLastError := VIS_ALREADY_OPEN;
      Exit;
    end;

  // Setup the input variables

  CacheSize   := SMALL_CACHE;
  LicenseKey  := LicKey;

  // Attempt to open it

  fLastError := VmxOpen(@DSet,
                        @CacheSize,
                        @AccessMode,
                        @fHandle,
                        @LicenseKey);

  // Return

  if fLastError = VIS_OK then
    begin
      fOpen := True;
      fDataset := Dataset;
      Result := True;
    end;
end;

//**********************************************************************************************************************
// Close
// Closes the currently opened dataset
//**********************************************************************************************************************

function TIsamTool.Close: boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Close it

  fLastError := VmxClose(@fHandle);

  // Return

  if fLastError = VIS_OK then
    begin
      fHandle := 0;
      fOpen := False;
      fDataset := '';
      Result := True;
    end;
end;

//**********************************************************************************************************************
// CreateNew
// Creates a new dataset with the specific name, primary key length and 
format
//**********************************************************************************************************************

function TIsamTool.CreateNew(const DSet: string; const MaxPKeyLength: 
smallint; const StandardFormat: string): boolean;
var
  GpSz: longint;
  Options: smallint;
  InitAlloc: smallint;
begin
  Result := False;

  // Check that a dataset is not already open

  if fOpen then
    begin
      fLastError := VIS_ALREADY_OPEN;
      Exit;
    end;

  // Setup the input variables

  GpSz           := 0;
  InitAlloc      := 0;
  Options        := 0;

  // Attempt to create it

  fLastError := VmxCreate(@DSet,
                          @MaxPKeyLength,
                          @GpSz,
                          @InitAlloc,
                          @Options,
                          @StandardFormat);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Add
// Adds a new record from the specified address using the specified 
primary key. If the primary key is blank, it is
// automatically allocated.
//**********************************************************************************************************************

function TIsamTool.Add(const RecAddr: pointer; const PKey: string): 
boolean;
var
  Pk: string;
  UpdateMode: smallint;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Setup the input variables

  UpdateMode := ADD_ONLY;

  if Length(PKey) = 0 then
    Pk := GetNextPrimaryKey
  else
    Pk := PKey;

  // Put the data

  fLastError := VmxPut(@fHandle,
                       @Pk,
                       RecAddr,
                       @UpdateMode);

  // Update fPrimaryKey

  fPrimaryKey := Pk;

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Replace
// Replaces the record from the specified address using the specified 
primary key.
//**********************************************************************************************************************

function TIsamTool.Replace(const RecAddr: pointer; const PKey: string): 
boolean;
var
  UpdateMode: smallint;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Setup the input variables

  UpdateMode := REPLACE_ONLY;

  // Put the data

  fLastError := VmxPut(@fHandle,
                       @PKey,
                       RecAddr,
                       @UpdateMode);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Next
// Gets the next record according to the specified index, selector and 
comparison method.
//**********************************************************************************************************************

function TIsamTool.Next(const RecAddr: pointer; const Index: smallint; 
const Selector: string; const Compare: smallint): boolean;
var
  Options: smallint;
  RIndexEntry: string;
  RPrimaryKey: string;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Setup the input variables

  Options := XNEXT + Compare + XGET_DATA;

  RIndexEntry := '';
  RPrimaryKey := '';

  // Get the data

  fLastError := VmxGet(@fHandle,
                       @Index,
                       @Options,
                       @Selector,
                       @RIndexEntry,
                       @RPrimaryKey,
                       RecAddr);

  // Update fPrimaryKey

  fPrimaryKey := RPrimaryKey;

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Prev
// Gets the previous record according to the specified index, selector 
and comparison method.
//**********************************************************************************************************************

function TIsamTool.Prev(const RecAddr: pointer; const Index: smallint; 
const Selector: string; const Compare: smallint): boolean;
var
  Options: smallint;
  RIndexEntry: string;
  RPrimaryKey: string;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Setup the input variables

  Options := XPREVIOUS + Compare + XGET_DATA;

  RIndexEntry := '';
  RPrimaryKey := '';

  // Get the data

  fLastError := VmxGet(@fHandle,
                       @Index,
                       @Options,
                       @Selector,
                       @RIndexEntry,
                       @RPrimaryKey,
                       RecAddr);

  // Update fPrimaryKey

  fPrimaryKey := RPrimaryKey;

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Lookup
// Looks up the record according to the specified index and selector
//**********************************************************************************************************************

function TIsamTool.Lookup(const RecAddr: pointer; const Index: smallint; 
const Selector: string): boolean;
var
  Options: smallint;
  RIndexEntry: string;
  RPrimaryKey: string;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Setup the input variables

  Options := XLOOKUP + XANY+ XGET_DATA;

  RIndexEntry := '';
  RPrimaryKey := '';

  // Get the data

  fLastError := VmxGet(@fHandle,
                       @Index,
                       @Options,
                       @Selector,
                       @RIndexEntry,
                       @RPrimaryKey,
                       RecAddr);

  // Update fPrimaryKey

  fPrimaryKey := RPrimaryKey;

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Delete
// Deletes the record according to the specified primary key
//**********************************************************************************************************************

function TIsamTool.Delete(const PKey: string): boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Delete the data

  fLastError := VmxDelete(@fHandle,
                          @PKey);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Bof
// Goes to the start of the dataset via the specified index
//**********************************************************************************************************************

function TIsamTool.Bof(const Index: smallint): boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Go to the start

  fLastError := VmxBof(@fHandle,
                       @Index);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Eof
// Goes to the end of the dataset via the specified index
//**********************************************************************************************************************

function TIsamTool.Eof(const Index: smallint): boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Go to the end

  fLastError := VmxEof(@fHandle,
                       @Index);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Lock
// Locks the dataset according to the specified lock string
//**********************************************************************************************************************

function TIsamTool.Lock(const LString: string): boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Lock

  fLastError := VmxLock(@fHandle,
                        @LString);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// UnLock
// Unlocks the dataset according to the specified lock string
//**********************************************************************************************************************

function TIsamTool.UnLock(const LString: string): boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Lock

  fLastError := VmxUnLock(@fHandle,
                          @LString);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Kill
// Deletes all files relevant to the specified dataset
//**********************************************************************************************************************

function TIsamTool.Kill(const DSet: string): boolean;
begin
  Result := False;

  // Check that a dataset is not currently open

  if fOpen then
    begin
      fLastError := VIS_ALREADY_OPEN;
      Exit;
    end;

  // Kill it

  fLastError := VmxKill(@DSet);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// WriteNote
// Writes the specified note and contents to the dataset note directory
//**********************************************************************************************************************

function TIsamTool.WriteNote(const Name: string; const Contents: 
string): boolean;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Lock

  fLastError := VmxWriteNote(@fHandle,
                             @Name,
                             @Contents);

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// ReadNote
// Reads the specified note contents from the dataset note directory
//**********************************************************************************************************************

function TIsamTool.ReadNote(const Name: string; var Contents: string): 
boolean;
var
  RContents: string;
begin
  Result := False;

  // Check that a dataset is currently open

  if not fOpen then
    begin
      fLastError := VIS_BAD_DATASET_NUMBER;
      Exit;
    end;

  // Setup the input variables

  RContents := '';

  // Lock

  fLastError := VmxReadNote(@fHandle,
                            @Name,
                            @RContents);

  // Setup the note contents

  Contents := RContents;

  // Return

  if fLastError = VIS_OK then
    Result := True;
end;

//**********************************************************************************************************************
// Register
// Registers the component on the SEPlus page
//**********************************************************************************************************************

procedure Register;
begin
  RegisterComponents('SEPlus', [TIsamTool]);
end;

// Specify where to find the VBIS4032 functions

function VmxCreate;    external 'VBIS4032.DLL' name 'VmxCreate';
function VmxOpen;      external 'VBIS4032.DLL' name 'VmxOpen';
function VmxClose;     external 'VBIS4032.DLL' name 'VmxClose';
function VmxGet;       external 'VBIS4032.DLL' name 'VmxGet';
function VmxPut;       external 'VBIS4032.DLL' name 'VmxPut';
function VmxDelete;    external 'VBIS4032.DLL' name 'VmxDelete';
function VmxBOF;       external 'VBIS4032.DLL' name 'VmxBOF';
function VmxEOF;       external 'VBIS4032.DLL' name 'VmxEOF';
function VmxInfo;      external 'VBIS4032.DLL' name 'VmxInfo';
function VmxLock;      external 'VBIS4032.DLL' name 'VmxLock';
function VmxUnlock;    external 'VBIS4032.DLL' name 'VmxUnLock';
function VmxKill;      external 'VBIS4032.DLL' name 'VmxKill';
function VmxReadNote;  external 'VBIS4032.DLL' name 'VmxReadNote';
function VmxWriteNote; external 'VBIS4032.DLL' name 'VmxWriteNote';

// That's all folks !

end.
